IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Clientes_Localidad]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Clientes_Localidad]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Clientes_Localidad] (@pJson VARCHAR(8000)) 
AS 
SET NOCOUNT ON 

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Pais				CHAR (3)
/*FIN Variables recibidas por parametro a traves del JSON*/

	SET @pId_Pais			= ISNULL(CONVERT(CHAR, dbo.CF_JSON_VALUE(@pJson,'Id_Pais')), '')
	SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
	SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)


DECLARE @Descripcion_Pais	VARCHAR (30)
DECLARE @Id_Provincia		CHAR (3)
DECLARE @Id_Localidad		INT
DECLARE @Json_Rta			NVARCHAR(MAX)

	SET @Descripcion_Pais	= ISNULL((SELECT Descripcion FROM Tab_Paises WHERE Id_Pais = @pId_Pais),'')
	SET @Id_Provincia		= ISNULL((SELECT MAX(Id_Provincia) FROM Tab_Provincias WHERE Id_Pais = @pId_Pais),'')-- alfanumerica
	SET @Id_Localidad		= ISNULL((SELECT MAX(Id_Localidad) FROM Tab_Localidades WHERE Id_Pais = @pId_Pais AND Id_Provincia=@Id_Provincia),0)--numerica


	IF (@Id_Provincia='')
	BEGIN
		SET @Id_Provincia		= ISNULL((SELECT Id_Pais FROM Tab_Paises WHERE Id_Pais = @pId_Pais),'')-- alfanumerica
		PRINT 'Provincia Vacia'

		INSERT INTO Tab_Provincias (Id_Provincia,	Descripcion,		Id_Pais)
							VALUES (@pId_Pais,		@Descripcion_Pais,  @pId_Pais)
		PRINT 'Se inserta en Tab_Provincias'
	END

	IF (@Id_Localidad=0)
	BEGIN

		SET @Id_Localidad		= ISNULL((SELECT MAX(Id_Localidad) FROM Tab_Localidades WHERE Id_Pais = @pId_Pais),0)--numerica
	
			IF (@Id_Localidad = 0) 
			BEGIN
			
				SET @Id_Localidad		= (SELECT MAX(Id_Localidad) FROM Tab_Localidades) 
				SET @Id_Localidad		= @Id_Localidad +1
				PRINT 'Localidad Vacia'
				INSERT INTO Tab_Localidades (Id_Localidad, Id_Pais,		Descripcion,		Id_Provincia)
									 VALUES (@Id_Localidad, @pId_Pais,	@Descripcion_Pais,	@Id_Provincia)
				PRINT 'Se inserta en Tab_Localidades'
				
			END	
	END

	SET @Json_Rta='{'
	SET @Json_Rta = @Json_Rta +	dbo.CF_Json_ParsearVariable('Id_Localidad', @Id_Localidad, 'INT') + ','
	SET @Json_Rta = @Json_Rta +	dbo.CF_Json_ParsearVariable('Id_Provincia', @Id_Provincia, 'CHAR (3)') 
	SET @Json_Rta = @Json_Rta + '}'

	SELECT  @Json_Rta as 'Respuesta'
